/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.data.IAnimation;
import noppes.npcs.api.entity.data.IAnimationFrame;
import noppes.npcs.client.model.animation.AddedPartConfig;
import noppes.npcs.client.model.animation.AnimationDamageHitbox;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.entity.EntityCustomNpc;

public class AnimationConfig
implements IAnimation {
    public static final AnimationConfig EMPTY = new AnimationConfig();
    public String name = "Default Animation";
    public int repeatLast = 0;
    public final Map<Integer, AnimationFrameConfig> frames = new TreeMap<Integer, AnimationFrameConfig>();
    public final Map<Integer, List<AddedPartConfig>> addParts = new TreeMap<Integer, List<AddedPartConfig>>();
    public final Map<Integer, Integer> endingFrameTicks = new TreeMap<Integer, Integer>();
    public int totalTicks = 0;
    public int id = -1;
    public AnimationKind type = AnimationKind.STANDING;
    public float chance = 1.0f;
    public boolean immutable;
    public int editTick = 0;
    public int editFrame = 0;

    public AnimationConfig() {
        this.frames.put(0, new AnimationFrameConfig(0));
    }

    @Override
    public IAnimationFrame addFrame() {
        int f = this.frames.size();
        this.frames.put(f, new AnimationFrameConfig(f));
        if (f == 0) {
            this.frames.get((Object)Integer.valueOf((int)f)).isNowDamage = true;
        }
        return this.frames.get(f);
    }

    @Override
    public IAnimationFrame addFrame(int frameId, IAnimationFrame frame) {
        if (frame == null) {
            return this.addFrame();
        }
        if (frameId < 0) {
            frameId = this.frames.size();
            this.frames.put(frameId, ((AnimationFrameConfig)frame).copy());
            this.frames.get((Object)Integer.valueOf((int)frameId)).id = frameId;
        } else {
            TreeMap<Integer, AnimationFrameConfig> newFrames = new TreeMap<Integer, AnimationFrameConfig>();
            int j = 0;
            for (int i : this.frames.keySet()) {
                if (i == frameId) {
                    newFrames.put(j, ((AnimationFrameConfig)frame).copy());
                    ((AnimationFrameConfig)newFrames.get((Object)Integer.valueOf((int)j))).id = j;
                    ++j;
                }
                newFrames.put(j, this.frames.get(i));
                ((AnimationFrameConfig)newFrames.get((Object)Integer.valueOf((int)j))).id = j;
                ++j;
            }
            this.frames.clear();
            this.frames.putAll(newFrames);
        }
        this.frames.get((Object)Integer.valueOf((int)frameId)).isNowDamage = this.frames.size() == 1;
        return this.frames.get(frameId);
    }

    public AnimationConfig copy() {
        AnimationConfig ac = new AnimationConfig();
        ac.load(this.save());
        ac.resetTicks();
        return ac;
    }

    @Override
    public IAnimationFrame getFrame(int frameId) {
        if (!this.frames.containsKey(frameId)) {
            throw new CustomNPCsException("Unknown frame " + frameId, new Object[0]);
        }
        return this.frames.get(frameId);
    }

    @Override
    public IAnimationFrame[] getFrames() {
        IAnimationFrame[] frames = new IAnimationFrame[this.frames.size()];
        for (int id : this.frames.keySet()) {
            frames[id] = this.frames.get(id);
        }
        return frames;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INbt getNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.save());
    }

    @Override
    public int getRepeatLast() {
        return this.repeatLast;
    }

    public String getSettingName() {
        return "ID:\u00a77" + this.id + '\u00a7' + "r " + this.name;
    }

    @Override
    public boolean hasFrame(int frameId) {
        return this.frames.containsKey(frameId);
    }

    public void load(NBTTagCompound compound) {
        int i;
        this.frames.clear();
        this.id = compound.func_74762_e("ID");
        this.name = compound.func_74779_i("Name");
        boolean hasDelayAttack = false;
        for (i = 0; i < compound.func_150295_c("FrameConfigs", 10).func_74745_c(); ++i) {
            AnimationFrameConfig afc = new AnimationFrameConfig();
            afc.load(compound.func_150295_c("FrameConfigs", 10).func_150305_b(i));
            afc.id = i;
            if (!hasDelayAttack && afc.isNowDamage()) {
                hasDelayAttack = true;
            }
            this.frames.put(i, afc);
        }
        if (this.frames.isEmpty()) {
            this.frames.put(0, new AnimationFrameConfig(0));
        }
        if (!hasDelayAttack) {
            this.frames.get((Object)Integer.valueOf((int)0)).isNowDamage = true;
        }
        this.addParts.clear();
        i = 0;
        int id = 8;
        while (i < compound.func_150295_c("AddedParts", 10).func_74745_c()) {
            AddedPartConfig addPart = new AddedPartConfig();
            addPart.load(compound.func_150295_c("AddedParts", 10).func_150305_b(i));
            addPart.id = id;
            if (!this.addParts.containsKey(addPart.parentPart)) {
                this.addParts.put(addPart.parentPart, new ArrayList());
            }
            this.addParts.get(addPart.parentPart).add(addPart);
            ++i;
            ++id;
        }
        if (compound.func_150297_b("Chance", 5)) {
            this.setChance(compound.func_74760_g("Chance"));
        }
        if (compound.func_150297_b("Immutable", 1)) {
            this.immutable = compound.func_74767_n("Immutable");
        }
        if (compound.func_150297_b("Type", 3)) {
            this.type = AnimationKind.get(compound.func_74762_e("Type"));
        }
        if (compound.func_150297_b("RepeatLast", 3)) {
            this.setRepeatLast(compound.func_74762_e("RepeatLast"));
        }
        if (compound.func_150297_b("DamageHitbox", 9) && compound.func_150295_c("DamageHitbox", 6).func_74745_c() == 6) {
            AnimationDamageHitbox aDHB = new AnimationDamageHitbox(0);
            NBTTagList listO = compound.func_150295_c("OffsetHitbox", 5);
            for (int j = 0; j < 3 && j < listO.func_74745_c(); ++j) {
                aDHB.offset[j] = listO.func_150308_e(j);
            }
            NBTTagList listS = compound.func_150295_c("ScaleHitbox", 5);
            for (int j = 0; j < 3 && j < listS.func_74745_c(); ++j) {
                aDHB.scale[j] = listS.func_150308_e(j);
            }
            int tTicks = 0;
            for (AnimationFrameConfig aFC : this.frames.values()) {
                tTicks += aFC.speed;
                if (aFC.isNowDamage()) {
                    aFC.damageDelay = tTicks;
                    if (!aFC.damageHitboxes.isEmpty()) break;
                    aFC.damageHitboxes.put(0, aDHB);
                    break;
                }
                tTicks += aFC.delay;
            }
        }
        CustomNpcs.proxy.loadAnimationModel(this);
    }

    @Override
    public void removeFrame(IAnimationFrame frameId) {
        if (frameId == null || this.frames.size() <= 1) {
            return;
        }
        for (int f : this.frames.keySet()) {
            if (!this.frames.get(f).equals(frameId)) continue;
            this.removeFrame(f);
            return;
        }
    }

    @Override
    public void removeFrame(int frameId) {
        if (!this.frames.containsKey(frameId)) {
            throw new CustomNPCsException("Unknown frame ID:" + frameId, new Object[0]);
        }
        TreeMap<Integer, AnimationFrameConfig> newData = new TreeMap<Integer, AnimationFrameConfig>();
        int i = 0;
        boolean isDel = false;
        for (int f : this.frames.keySet()) {
            if (f == frameId) {
                isDel = true;
                continue;
            }
            newData.put(i, this.frames.get(f).copy());
            ((AnimationFrameConfig)newData.get((Object)Integer.valueOf((int)i))).id = i;
            ++i;
        }
        if (isDel) {
            this.frames.clear();
            if (newData.isEmpty()) {
                newData.put(0, new AnimationFrameConfig(0));
            }
            this.frames.putAll(newData);
        }
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            name = "Default Animation";
        }
        this.name = name;
    }

    @Override
    public void setNbt(INbt nbt) {
        this.load(nbt.getMCNBT());
    }

    @Override
    public void setRepeatLast(int frames) {
        if (frames < 0) {
            frames = 0;
        }
        if (frames > this.frames.size()) {
            frames = this.frames.size();
        }
        this.repeatLast = frames;
    }

    @Override
    public void setChance(float chance) {
        if (chance < 0.0f) {
            chance *= -1.0f;
        }
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        this.chance = chance;
    }

    public void startToNpc(EntityCustomNpc npcEntity) {
        if (npcEntity == null || npcEntity.modelData == null || npcEntity.modelData.entityClass != null) {
            return;
        }
        npcEntity.animation.tryRunAnimation(this, this.type);
        if (npcEntity.field_70170_p == null || npcEntity.field_70170_p.field_72995_K) {
            return;
        }
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.UPDATE_NPC_ANIMATION, npcEntity.field_70170_p.field_73011_w.getDimension(), 3, npcEntity.func_145782_y(), this.save());
    }

    @Override
    public void startToNpc(ICustomNpc<?> npc) {
        if (npc == null || !(npc.getMCEntity() instanceof EntityCustomNpc)) {
            throw new CustomNPCsException("NPC must not be null", new Object[0]);
        }
        this.startToNpc((EntityCustomNpc)((Object)npc.getMCEntity()));
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listFC = new NBTTagList();
        Iterator<AnimationFrameConfig> setts = this.frames.values().iterator();
        while (setts.hasNext()) {
            try {
                AnimationFrameConfig afc = setts.next();
                listFC.func_74742_a((NBTBase)afc.writeNBT());
            }
            catch (Exception e) {
                LogWriter.error(e);
                break;
            }
        }
        compound.func_74782_a("FrameConfigs", (NBTBase)listFC);
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Type", this.type.get());
        compound.func_74768_a("RepeatLast", this.repeatLast);
        compound.func_74778_a("Name", this.name);
        compound.func_74776_a("Chance", this.chance);
        compound.func_74757_a("Immutable", this.immutable);
        NBTTagList listAP = new NBTTagList();
        for (int partId : this.addParts.keySet()) {
            for (AddedPartConfig addedPart : this.addParts.get(partId)) {
                listAP.func_74742_a((NBTBase)addedPart.save());
            }
        }
        compound.func_74782_a("AddedParts", (NBTBase)listAP);
        return compound;
    }

    public void resetTicks() {
        this.totalTicks = 0;
        this.endingFrameTicks.clear();
        if (this == EMPTY) {
            this.totalTicks = AnimationFrameConfig.EMPTY.speed + AnimationFrameConfig.EMPTY.delay + 1;
            this.endingFrameTicks.put(0, this.totalTicks);
            return;
        }
        for (Integer id : this.frames.keySet()) {
            AnimationFrameConfig frame = this.frames.get(id);
            if (frame.speed < 1) {
                frame.speed = 1;
            }
            this.totalTicks += frame.speed;
            if (frame.isNowDamage()) {
                frame.damageDelay = this.totalTicks;
            }
            this.totalTicks += frame.delay;
            this.endingFrameTicks.put(id, this.totalTicks);
        }
        if (this.totalTicks == 0) {
            this.totalTicks = 1;
        }
    }

    public boolean hasEmotion() {
        for (AnimationFrameConfig frame : this.frames.values()) {
            if (frame.emotionId < 0) continue;
            return true;
        }
        return false;
    }

    public List<AxisAlignedBB> getDamageHitboxes(EntityLivingBase npc, int frameID) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (!this.frames.containsKey(frameID)) {
            return list;
        }
        for (AnimationDamageHitbox aDHb : this.frames.get((Object)Integer.valueOf((int)frameID)).damageHitboxes.values()) {
            list.add(aDHb.getScaledDamageHitbox(npc));
        }
        return list;
    }

    public int getAnimationFrameByTime(long ticks) {
        if (this.type == AnimationKind.EDITING_PART) {
            return this.editFrame;
        }
        if (ticks >= 0L) {
            if (this.endingFrameTicks.isEmpty() && !this.frames.isEmpty()) {
                this.resetTicks();
            }
            for (int id : this.endingFrameTicks.keySet()) {
                if (ticks > (long)this.endingFrameTicks.get(id).intValue()) continue;
                return id;
            }
            return this.frames.size();
        }
        return -1;
    }

    public AddedPartConfig getAddedPart(int id) {
        for (List<AddedPartConfig> list : this.addParts.values()) {
            for (AddedPartConfig addedPart : list) {
                if (addedPart.id != id) continue;
                return addedPart;
            }
        }
        return null;
    }

    public void removeAddedPart(AddedPartConfig addedPartConfig) {
        if (addedPartConfig == null) {
            return;
        }
        int addedPartId = addedPartConfig.id;
        boolean bo = false;
        if (this.addParts.containsKey(addedPartConfig.parentPart) && !(bo = this.addParts.get(addedPartConfig.parentPart).remove(addedPartConfig))) {
            for (AddedPartConfig addedPart : this.addParts.get(addedPartConfig.parentPart)) {
                if (addedPart.id != addedPartId) continue;
                bo = this.addParts.get(addedPartConfig.parentPart).remove(addedPart);
                break;
            }
        }
        if (!bo) {
            this.removeAddedPart(addedPartId);
        }
        if (bo) {
            for (AnimationFrameConfig frame : this.frames.values()) {
                frame.parts.remove(addedPartId);
            }
        }
    }

    public void removeAddedPart(int addedPartId) {
        boolean bo = false;
        Iterator<Object> iterator = this.addParts.keySet().iterator();
        block0: while (iterator.hasNext()) {
            int partId = iterator.next();
            for (AddedPartConfig addedPart : this.addParts.get(partId)) {
                if (addedPart.id != addedPartId) continue;
                bo = this.addParts.get(partId).remove(addedPart);
                continue block0;
            }
        }
        if (bo) {
            for (AnimationFrameConfig frame : this.frames.values()) {
                frame.parts.remove(addedPartId);
            }
        }
    }

    static {
        AnimationConfig.EMPTY.frames.put(0, AnimationFrameConfig.EMPTY);
        EMPTY.resetTicks();
    }
}

